// popup-loader.js - Loads remote UI from server
(async function() {
  try {
    const BACKEND_URL = window.CAPYNEWS_CONFIG?.BACKEND_URL || 'https://cyber-cloud.tryforge.sh';

    const response = await fetch(`${BACKEND_URL}/popup-ui`);
    const ui = await response.json();

    // Inject CSS
    document.getElementById('remote-styles').textContent = ui.css;

    // Inject HTML
    const container = document.getElementById('app-container');
    container.innerHTML = ui.html;
    container.style.display = 'block';

    // Hide loading
    document.querySelector('.loading-initial').style.display = 'none';

    // Now load the popup.js which handles all the logic
    const script = document.createElement('script');
    script.src = 'popup.js';
    script.onload = () => {
      // Initialize popup after script loads
      if (window.initPopup) {
        window.initPopup();
      }
    };
    document.body.appendChild(script);

  } catch (error) {
    document.body.innerHTML = `
      <div style="padding: 20px; color: #ff6464; font-size: 11px; text-align: center;">
        <div style="margin-bottom: 10px;">⚠️ failed to load ui</div>
        <div style="color: #666;">${error.message}</div>
        <div style="margin-top: 12px; font-size: 10px;">
          check that server is running at:<br>
          <code style="color: #00d9ff;">${window.CAPYNEWS_CONFIG?.BACKEND_URL || 'server url'}</code>
        </div>
      </div>
    `;
  }
})();
